<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>لوحة إرسال الإشعارات - OneSignal</title>
    <style>
        body {
            margin: 0;
            font-family: sans-serif;
            background: #f2f2f2;
        }
        header {
            background: #1e1e2d;
            color: white;
            padding: 20px;
            text-align: center;
            font-size: 24px;
            font-weight: bold;
        }
        .container {
            width: 90%;
            max-width: 700px;
            margin: 40px auto;
            background: white;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        }
        label {
            display: block;
            margin-bottom: 6px;
            font-weight: bold;
            font-size: 16px;
        }
        input, textarea {
            width: 100%;
            padding: 12px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 8px;
            font-size: 15px;
        }
        button {
            width: 100%;
            padding: 14px;
            background: #0077ff;
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 18px;
            cursor: pointer;
            transition: 0.3s;
        }
        button:hover {
            background: #005bd1;
        }
        .success {
            background: #d4f5d4;
            padding: 12px;
            margin-top: 15px;
            border-radius: 8px;
            color: #0a6f0a;
            text-align: center;
        }
        .error {
            background: #ffdada;
            padding: 12px;
            margin-top: 15px;
            border-radius: 8px;
            color: #b70000;
            text-align: center;
        }
    </style>
</head>
<body>
    <header>📢 لوحة إرسال الإشعارات - OneSignal</header>

    <div class="container">
        <form method="POST" action="">
            <label>عنوان الإشعار</label>
            <input type="text" name="title" placeholder="اكتب عنوان الإشعار" required>

            <label>محتوى الإشعار</label>
            <textarea name="message" placeholder="اكتب محتوى الإشعار" rows="5" required></textarea>

            <label>رابط عند الضغط (اختياري)</label>
            <input type="text" name="url" placeholder="https://example.com">

            <label>رابط الصورة (اختياري)</label>
            <input type="text" name="image" placeholder="https://example.com/image.jpg">

            <button type="submit">إرسال الإشعار</button>
        </form>

    <?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

  $restKey = "os_v2_app_ha2vubzwk5h4ffvnhbfolsuu5hckrmeupbreivugfcpobtta3rtpalefsng2h7vcwgfosh3mqezohs7az27hp2rfqz2mpk6nbeki6vq";
  $appId   = "38355a07-3657-4fc2-96ad-384ae5ca94e9";

    $title = $_POST['title'];
    $message = $_POST['message'];
    $url = isset($_POST['url']) ? $_POST['url'] : '';
    $image = isset($_POST['image']) ? $_POST['image'] : '';

    $fields = [
        'app_id' => $appId,
        'included_segments' => ['All'],
        'headings' => ['en' => $title, 'ar' => $title],
        'contents' => ['en' => $message, 'ar' => $message],
    ];

    if(!empty($url)) {
        $fields['url'] = $url;
    }

    if(!empty($image)) {
        $fields['big_picture'] = $image;
    }

    $fields = json_encode($fields, JSON_UNESCAPED_UNICODE);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic ' . $restKey
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    curl_close($ch);

    if ($httpCode == 200) {
        echo '<div class="success">✔ تم إرسال الإشعار بنجاح!</div>';
    } else {
        echo '<div class="error">❌ فشل إرسال الإشعار!</div>';
        echo "<pre>$response</pre>";
    }
}
?>
   
    </div>
</body>
</html>