<?php
$host = "localhost";
$user = "tasavkhx_tv";
$pass = "tasavkhx_tv";
$db   = "tasavkhx_tv";

$conn = new mysqli($host, $user, $pass, $db);
$conn->set_charset("utf8mb4"); // دعم العربية

$message = "";

if(isset($_POST['submit'])) {
    $team1_name = $_POST['team1_name'];
    $team1_logo = $_POST['team1_logo'];
    $team2_name = $_POST['team2_name'];
    $team2_logo = $_POST['team2_logo'];
    $match_time = $_POST['match_time'];
    $status = $_POST['status'];
    $channel = $_POST['channel'];
    $commentator = $_POST['commentator'];

    $stmt = $conn->prepare("INSERT INTO live_matches (team1_name, team1_logo, team2_name, team2_logo, match_time, status, channel, commentator) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssssss", $team1_name, $team1_logo, $team2_name, $team2_logo, $match_time, $status, $channel, $commentator);

    if($stmt->execute()){
        $message = "تم إضافة المباراة بنجاح ✅";
    } else {
        $message = "حدث خطأ أثناء الإضافة ❌";
    }

    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>لوحة إضافة المباريات المباشرة</title>
<style>
    body {
        font-family: Arial, sans-serif;
        background: #f2f2f2;
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 100vh;
    }
    .panel {
        background: #fff;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 0 15px rgba(0,0,0,0.1);
        width: 450px;
    }
    h2 {
        text-align: center;
        margin-bottom: 20px;
        color: #333;
    }
    input, select, button {
        width: 100%;
        padding: 10px;
        margin-bottom: 15px;
        border-radius: 5px;
        border: 1px solid #ccc;
        font-size: 16px;
    }
    button {
        background: #28a745;
        color: #fff;
        border: none;
        cursor: pointer;
    }
    button:hover {
        background: #218838;
    }
    .message {
        text-align: center;
        margin-bottom: 15px;
        color: green;
    }
</style>
</head>
<body>

<div class="panel">
    <h2>إضافة مباراة مباشرة</h2>
    <?php if($message) echo "<div class='message'>$message</div>"; ?>
    <form method="POST">
        <input type="text" name="team1_name" placeholder="اسم الفريق الأول" required>
        <input type="text" name="team1_logo" placeholder="رابط شعار الفريق الأول">
        <input type="text" name="team2_name" placeholder="اسم الفريق الثاني" required>
        <input type="text" name="team2_logo" placeholder="رابط شعار الفريق الثاني">
        <input type="datetime-local" name="match_time" placeholder="وقت المباراة" required>
        <select name="status" required>
            <option value="">اختر حالة المباراة</option>
            <option value="لم تبدأ">لم تبدأ</option>
            <option value="مباشر الآن">مباشر الآن</option>
            <option value="انتهت">انتهت</option>
        </select>
        <input type="text" name="channel" placeholder="القناة الناقلة">
        <input type="text" name="commentator" placeholder="المعلق">
        <button type="submit" name="submit">إضافة المباراة</button>
    </form>
</div>

</body>
</html>
