<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نظام إدارة البث المباشر</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .container {
            max-width: 1200px;
            width: 100%;
        }

        .welcome-card {
            background: white;
            border-radius: 20px;
            padding: 50px;
            box-shadow: 0 10px 50px rgba(0,0,0,0.3);
            text-align: center;
            animation: fadeIn 0.8s;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(-30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .logo {
            font-size: 5em;
            color: #667eea;
            margin-bottom: 20px;
        }

        h1 {
            color: #333;
            font-size: 3em;
            margin-bottom: 15px;
        }

        p {
            color: #666;
            font-size: 1.3em;
            margin-bottom: 40px;
            line-height: 1.8;
        }

        .features {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 30px;
            margin: 40px 0;
        }

        .feature-box {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            padding: 30px;
            border-radius: 15px;
            transition: all 0.3s;
        }

        .feature-box:hover {
            transform: translateY(-10px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }

        .feature-box i {
            font-size: 3em;
            color: #667eea;
            margin-bottom: 15px;
        }

        .feature-box h3 {
            color: #333;
            font-size: 1.5em;
            margin-bottom: 10px;
        }

        .feature-box p {
            color: #666;
            font-size: 1em;
            margin: 0;
        }

        .buttons {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
            margin-top: 40px;
        }

        .btn {
            padding: 18px 40px;
            border: none;
            border-radius: 50px;
            font-size: 1.2em;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 10px;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        }

        .btn-secondary {
            background: white;
            color: #667eea;
            border: 3px solid #667eea;
        }

        .btn-secondary:hover {
            background: #667eea;
            color: white;
        }

        .api-section {
            margin-top: 50px;
            background: #f8f9fa;
            padding: 30px;
            border-radius: 15px;
        }

        .api-section h2 {
            color: #667eea;
            margin-bottom: 20px;
            font-size: 2em;
        }

        .api-list {
            display: grid;
            gap: 15px;
        }

        .api-item {
            background: white;
            padding: 20px;
            border-radius: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 15px;
        }

        .api-item code {
            background: #667eea;
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            font-size: 1em;
            flex: 1;
            min-width: 250px;
        }

        .api-item a {
            background: #28a745;
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            text-decoration: none;
            font-weight: bold;
            transition: all 0.3s;
        }

        .api-item a:hover {
            background: #218838;
            transform: scale(1.05);
        }

        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin: 40px 0;
        }

        .stat-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            border-radius: 15px;
            text-align: center;
        }

        .stat-card i {
            font-size: 3em;
            margin-bottom: 15px;
        }

        .stat-card h3 {
            font-size: 2.5em;
            margin-bottom: 5px;
        }

        .stat-card p {
            color: white;
            margin: 0;
        }

        @media (max-width: 768px) {
            .welcome-card {
                padding: 30px 20px;
            }

            h1 {
                font-size: 2em;
            }

            .buttons {
                flex-direction: column;
            }

            .btn {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="welcome-card">
            <div class="logo">
                <i class="fas fa-broadcast-tower"></i>
            </div>
            
            <h1>🎯 نظام إدارة البث المباشر</h1>
            <p>
                منصة احترافية متكاملة لإدارة القنوات التلفزيونية والمباريات المباشرة<br>
                مع نظام إشعارات فوري وواجهة عربية سهلة الاستخدام
            </p>

            <div class="buttons">
                <a href="login.php" class="btn btn-primary">
                    <i class="fas fa-sign-in-alt"></i>
                    دخول لوحة التحكم
                </a>
                <a href="README.md" class="btn btn-secondary" target="_blank">
                    <i class="fas fa-book"></i>
                    دليل الاستخدام
                </a>
            </div>

            <div class="features">
                <div class="feature-box">
                    <i class="fas fa-tv"></i>
                    <h3>إدارة القنوات</h3>
                    <p>إضافة وتعديل وحذف القنوات التلفزيونية بكل سهولة</p>
                </div>

                <div class="feature-box">
                    <i class="fas fa-futbol"></i>
                    <h3>إدارة المباريات</h3>
                    <p>متابعة المباريات المباشرة وجدولة المباريات القادمة</p>
                </div>

                <div class="feature-box">
                    <i class="fas fa-film"></i>
                    <h3>إدارة الأفلام</h3>
                    <p>مكتبة أفلام متكاملة مع التقييمات والتصنيفات</p>
                </div>

                <div class="feature-box">
                    <i class="fas fa-bell"></i>
                    <h3>إشعارات فورية</h3>
                    <p>إرسال إشعارات للمستخدمين عبر OneSignal</p>
                </div>

                <div class="feature-box">
                    <i class="fas fa-mobile-alt"></i>
                    <h3>واجهة متجاوبة</h3>
                    <p>تصميم عصري يعمل على جميع الأجهزة</p>
                </div>
            </div>

            <div class="stats">
                <div class="stat-card">
                    <i class="fas fa-shield-alt"></i>
                    <h3>100%</h3>
                    <p>آمن ومحمي</p>
                </div>
                <div class="stat-card">
                    <i class="fas fa-bolt"></i>
                    <h3>سريع</h3>
                    <p>أداء فائق</p>
                </div>
                <div class="stat-card">
                    <i class="fas fa-language"></i>
                    <h3>عربي</h3>
                    <p>دعم كامل</p>
                </div>
            </div>

            <div class="api-section">
                <h2><i class="fas fa-code"></i> واجهات برمجية API جاهزة</h2>
                <div class="api-list">
                    <div class="api-item">
                        <span><strong>📺 API القنوات:</strong></span>
                        <code><?php echo 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/api.php'; ?></code>
                        <a href="api.php" target="_blank">اختبار</a>
                    </div>
                    <div class="api-item">
                        <span><strong>⚽ API المباريات:</strong></span>
                        <code><?php echo 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/api_match.php'; ?></code>
                        <a href="api_match.php" target="_blank">اختبار</a>
                    </div>
                    <div class="api-item">
                        <span><strong>🎬 API الأفلام:</strong></span>
                        <code><?php echo 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/api_movies.php'; ?></code>
                        <a href="api_movies.php" target="_blank">اختبار</a>
                    </div>
                </div>
            </div>

            <div style="margin-top: 40px; padding-top: 30px; border-top: 2px solid #e0e0e0;">
                <h3 style="color: #667eea; margin-bottom: 15px;">
                    <i class="fas fa-rocket"></i> ابدأ الآن
                </h3>
                <p style="margin-bottom: 20px;">
                    تسجيل الدخول الافتراضي:<br>
                    <strong>اسم المستخدم:</strong> admin | <strong>كلمة المرور:</strong> admin123
                </p>
                <p style="color: #f5576c; font-size: 1em;">
                    <i class="fas fa-exclamation-triangle"></i>
                    تذكر تغيير بيانات تسجيل الدخول من ملف login.php
                </p>
            </div>
        </div>

        <div style="text-align: center; margin-top: 30px; color: white;">
            <p style="font-size: 1.1em;">
                تم التطوير بواسطة <strong>GitHub Copilot</strong> | نوفمبر 2025
            </p>
        </div>
    </div>

    <script>
        // إضافة تأثير عند تحميل الصفحة
        document.addEventListener('DOMContentLoaded', function() {
            const features = document.querySelectorAll('.feature-box');
            features.forEach((feature, index) => {
                setTimeout(() => {
                    feature.style.animation = 'fadeIn 0.5s';
                }, index * 100);
            });
        });
    </script>
</body>
</html>
