<?php
/**
 * ملف الإعدادات - Configuration File
 * 
 * هذا الملف يحتوي على جميع الإعدادات المهمة للنظام
 * This file contains all important system settings
 */

// ====================================
// إعدادات قاعدة البيانات
// Database Configuration
// ====================================

define('DB_HOST', 'localhost');           // اسم الخادم | Host name
define('DB_USER', 'tasavkhx_tv');        // اسم المستخدم | Username
define('DB_PASS', 'tasavkhx_tv');        // كلمة المرور | Password
define('DB_NAME', 'tasavkhx_tv');        // اسم قاعدة البيانات | Database name

// ====================================
// إعدادات OneSignal للإشعارات
// OneSignal Notification Settings
// ====================================

define('ONESIGNAL_REST_KEY', 'os_v2_app_ha2vubzwk5h4ffvnhbfolsuu5hckrmeupbreivugfcpobtta3rtpalefsng2h7vcwgfosh3mqezohs7az27hp2rfqz2mpk6nbeki6vq');
define('ONESIGNAL_APP_ID', '38355a07-3657-4fc2-96ad-384ae5ca94e9');

// ====================================
// إعدادات تسجيل الدخول
// Login Credentials
// ====================================

define('ADMIN_USERNAME', 'admin');       // اسم المستخدم للمشرف | Admin username
define('ADMIN_PASSWORD', 'admin123');    // كلمة المرور للمشرف | Admin password

// ⚠️ ملاحظة مهمة: غيّر كلمة المرور قبل استخدام النظام في بيئة الإنتاج
// Important: Change the password before using in production

// ====================================
// إعدادات النظام العامة
// General System Settings
// ====================================

define('SITE_NAME', 'لوحة التحكم الاحترافية');  // اسم الموقع | Site name
define('SITE_URL', 'http://localhost/yt');      // رابط الموقع | Site URL
define('TIMEZONE', 'Asia/Riyadh');              // المنطقة الزمنية | Timezone

// تعيين المنطقة الزمنية
date_default_timezone_set(TIMEZONE);

// ====================================
// إعدادات PHP
// PHP Settings
// ====================================

// تفعيل عرض الأخطاء في بيئة التطوير فقط
// Enable error display in development environment only
if ($_SERVER['SERVER_NAME'] === 'localhost') {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0);
    error_reporting(0);
}

// ====================================
// دالة الاتصال بقاعدة البيانات
// Database Connection Function
// ====================================

function getDBConnection() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conn->connect_error) {
        die("فشل الاتصال بقاعدة البيانات: " . $conn->connect_error);
    }
    
    $conn->set_charset("utf8mb4");
    return $conn;
}

// ====================================
// دالة إرسال الإشعارات
// Send Notification Function
// ====================================

function sendNotification($title, $message, $url = '', $image = '') {
    $fields = [
        'app_id' => ONESIGNAL_APP_ID,
        'included_segments' => ['All'],
        'headings' => ['en' => $title, 'ar' => $title],
        'contents' => ['en' => $message, 'ar' => $message],
    ];

    if (!empty($url)) {
        $fields['url'] = $url;
    }

    if (!empty($image)) {
        $fields['big_picture'] = $image;
    }

    $fields = json_encode($fields, JSON_UNESCAPED_UNICODE);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic ' . ONESIGNAL_REST_KEY
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    return $httpCode == 200;
}

// ====================================
// دالة التحقق من تسجيل الدخول
// Check Login Function
// ====================================

function checkLogin() {
    if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
        header("Location: login.php");
        exit;
    }
}

// ====================================
// دالة تنظيف المدخلات
// Sanitize Input Function
// ====================================

function cleanInput($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

// ====================================
// دالة عرض الرسائل
// Display Message Function
// ====================================

function showMessage($message, $type = 'success') {
    $icon = $type === 'success' ? 'check-circle' : 'exclamation-circle';
    return "
    <div class='message $type'>
        <i class='fas fa-$icon'></i>
        $message
    </div>
    ";
}
?>
