<?php
// simple_admin_panel.php
// Basic example admin panel using PHP + MySQL (no framework)

// 1. Database connection
$host = "localhost";
$user = "tasavkhx_tv";
$pass = "tasavkhx_tv";
$db   = "tasavkhx_tv";
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
$conn->set_charset("utf8mb4");

// 2. Insert channel
if (isset($_POST['add'])) {
    $title     = $_POST['title'];
    $url       = $_POST['url'];
    $pic       = $_POST['pic'];
    $category  = $_POST['category'];

    $stmt = $conn->prepare("INSERT INTO channels (title, url, pic, category) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $title, $url, $pic, $category);
    $stmt->execute();
    echo "<p style='color:green;'>Channel added!</p>";
}

// 3. Fetch channels
$result = $conn->query("SELECT * FROM channels ORDER BY id DESC");
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Simple Admin Panel</title>
    <style>
        body {
            font-family: Arial;
            background: #f3f3f3;
            padding: 20px;
        }
        .container {
            width: 600px;
            margin: auto;
            background: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        input, select {
            width: 100%;
            padding: 10px;
            margin: 5px 0 15px;
            border-radius: 5px;
            border: 1px solid #ccc;
        }
        button {
            padding: 12px 20px;
            background: #3498db;
            color: #fff;
            border: none;
            cursor: pointer;
            border-radius: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid #ccc;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Add New Channel</h2>

    <form method="POST">
        <input type="text" name="title" placeholder="Channel Title" required>
        <input type="text" name="url" placeholder="Channel URL" required>
        <input type="text" name="pic" placeholder="Picture URL" required>
        <select name="category">
            <option value="News">News</option>
            <option value="Sports">Sports</option>
            <option value="Movies">Movies</option>
            <option value="Kids">Kids</option>
        </select>
        <button type="submit" name="add">Add Channel</button>
    </form>

    <h2>Channels List</h2>
    <table>
        <tr>
            <th>ID</th>
            <th>Title</th>
            <th>Category</th>
        </tr>
        <?php while ($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?= $row['id'] ?></td>
                <td><?= $row['title'] ?></td>
                <td><?= $row['category'] ?></td>
            </tr>
        <?php endwhile; ?>
    </table>
</div>
</body>
</html>
