<?php
header("Content-Type: application/json; charset=utf-8");

// Database connection
$host = "localhost";
$user = "tasavkhx_tv";
$pass = "tasavkhx_tv";
$db   = "tasavkhx_tv";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => "فشل الاتصال بقاعدة البيانات"], JSON_UNESCAPED_UNICODE);
    exit;
}

$conn->set_charset("utf8mb4");

// معالجة المعاملات
$genre = isset($_GET['genre']) ? $_GET['genre'] : null;
$search = isset($_GET['search']) ? $_GET['search'] : null;
$sort = isset($_GET['sort']) ? $_GET['sort'] : 'created_at';
$order = isset($_GET['order']) ? $_GET['order'] : 'DESC';
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 50;
$offset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;

// بناء الاستعلام
$sql = "SELECT * FROM movies WHERE 1=1";

if ($genre) {
    $genre = $conn->real_escape_string($genre);
    $sql .= " AND genre = '$genre'";
}

if ($search) {
    $search = $conn->real_escape_string($search);
    $sql .= " AND (title LIKE '%$search%' OR description LIKE '%$search%')";
}

// الترتيب
$allowed_sorts = ['created_at', 'rating', 'views', 'release_year', 'title'];
$sort = in_array($sort, $allowed_sorts) ? $sort : 'created_at';
$order = strtoupper($order) === 'ASC' ? 'ASC' : 'DESC';

$sql .= " ORDER BY $sort $order LIMIT $limit OFFSET $offset";

$result = $conn->query($sql);

$movies = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $movies[] = [
            "id" => (int)$row['id'],
            "title" => $row['title'],
            "description" => $row['description'],
            "poster" => $row['poster'],
            "video_url" => $row['video_url'],
            "duration" => $row['duration'],
            "release_year" => (int)$row['release_year'],
            "genre" => $row['genre'],
            "rating" => (float)$row['rating'],
            "quality" => $row['quality'],
            "language" => $row['language'],
            "views" => (int)$row['views'],
            "created_at" => $row['created_at']
        ];
    }
}

// إحصائيات إضافية
$total_query = "SELECT COUNT(*) as total FROM movies";
$total_result = $conn->query($total_query);
$total = $total_result->fetch_assoc()['total'];

echo json_encode([
    "status" => "success",
    "total" => (int)$total,
    "count" => count($movies),
    "limit" => $limit,
    "offset" => $offset,
    "data" => $movies
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

$conn->close();
?>
