<?php
session_start();

// التحقق من تسجيل الدخول
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header("Location: login.php");
    exit;
}

// Database connection
$host = "localhost";
$user = "tasavkhx_tv";
$pass = "tasavkhx_tv";
$db   = "tasavkhx_tv";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("فشل الاتصال بقاعدة البيانات: " . $conn->connect_error);
}
$conn->set_charset("utf8mb4");

$message = "";
$messageType = "";

// ==================== معالجة القنوات ====================
// إضافة قناة
if (isset($_POST['add_channel'])) {
    $title = $_POST['ch_title'];
    $url = $_POST['ch_url'];
    $pic = $_POST['ch_pic'];
    $category = $_POST['ch_category'];

    $stmt = $conn->prepare("INSERT INTO channels (title, url, pic, category) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $title, $url, $pic, $category);
    
    if ($stmt->execute()) {
        $message = "تم إضافة القناة بنجاح ✅";
        $messageType = "success";
    } else {
        $message = "حدث خطأ أثناء إضافة القناة ❌";
        $messageType = "error";
    }
    $stmt->close();
}

// حذف قناة
if (isset($_GET['delete_channel'])) {
    $id = intval($_GET['delete_channel']);
    $stmt = $conn->prepare("DELETE FROM channels WHERE id = ?");
    $stmt->bind_param("i", $id);
    
    if ($stmt->execute()) {
        $message = "تم حذف القناة بنجاح ✅";
        $messageType = "success";
    }
    $stmt->close();
}

// تعديل قناة
if (isset($_POST['edit_channel'])) {
    $id = intval($_POST['ch_id']);
    $title = $_POST['ch_title'];
    $url = $_POST['ch_url'];
    $pic = $_POST['ch_pic'];
    $category = $_POST['ch_category'];

    $stmt = $conn->prepare("UPDATE channels SET title=?, url=?, pic=?, category=? WHERE id=?");
    $stmt->bind_param("ssssi", $title, $url, $pic, $category, $id);
    
    if ($stmt->execute()) {
        $message = "تم تحديث القناة بنجاح ✅";
        $messageType = "success";
    }
    $stmt->close();
}

// ==================== معالجة المباريات ====================
// إضافة مباراة
if (isset($_POST['add_match'])) {
    $team1_name = $_POST['team1_name'];
    $team1_logo = $_POST['team1_logo'];
    $team2_name = $_POST['team2_name'];
    $team2_logo = $_POST['team2_logo'];
    $match_time = $_POST['match_time'];
    $status = $_POST['status'];
    $channel = $_POST['channel'];
    $commentator = $_POST['commentator'];

    $stmt = $conn->prepare("INSERT INTO live_matches (team1_name, team1_logo, team2_name, team2_logo, match_time, status, channel, commentator) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssssss", $team1_name, $team1_logo, $team2_name, $team2_logo, $match_time, $status, $channel, $commentator);
    
    if ($stmt->execute()) {
        $message = "تم إضافة المباراة بنجاح ✅";
        $messageType = "success";
    }
    $stmt->close();
}

// حذف مباراة
if (isset($_GET['delete_match'])) {
    $id = intval($_GET['delete_match']);
    $stmt = $conn->prepare("DELETE FROM live_matches WHERE id = ?");
    $stmt->bind_param("i", $id);
    
    if ($stmt->execute()) {
        $message = "تم حذف المباراة بنجاح ✅";
        $messageType = "success";
    }
    $stmt->close();
}

// تعديل مباراة
if (isset($_POST['edit_match'])) {
    $id = intval($_POST['match_id']);
    $team1_name = $_POST['team1_name'];
    $team1_logo = $_POST['team1_logo'];
    $team2_name = $_POST['team2_name'];
    $team2_logo = $_POST['team2_logo'];
    $match_time = $_POST['match_time'];
    $status = $_POST['status'];
    $channel = $_POST['channel'];
    $commentator = $_POST['commentator'];

    $stmt = $conn->prepare("UPDATE live_matches SET team1_name=?, team1_logo=?, team2_name=?, team2_logo=?, match_time=?, status=?, channel=?, commentator=? WHERE id=?");
    $stmt->bind_param("ssssssssi", $team1_name, $team1_logo, $team2_name, $team2_logo, $match_time, $status, $channel, $commentator, $id);
    
    if ($stmt->execute()) {
        $message = "تم تحديث المباراة بنجاح ✅";
        $messageType = "success";
    }
    $stmt->close();
}

// ==================== إرسال إشعار ====================
if (isset($_POST['send_notification'])) {
    $restKey = "os_v2_app_ha2vubzwk5h4ffvnhbfolsuu5hckrmeupbreivugfcpobtta3rtpalefsng2h7vcwgfosh3mqezohs7az27hp2rfqz2mpk6nbeki6vq";
    $appId   = "38355a07-3657-4fc2-96ad-384ae5ca94e9";

    $title = $_POST['notif_title'];
    $notif_message = $_POST['notif_message'];
    $url = isset($_POST['notif_url']) ? $_POST['notif_url'] : '';
    $image = isset($_POST['notif_image']) ? $_POST['notif_image'] : '';

    $fields = [
        'app_id' => $appId,
        'included_segments' => ['All'],
        'headings' => ['en' => $title, 'ar' => $title],
        'contents' => ['en' => $notif_message, 'ar' => $notif_message],
    ];

    if (!empty($url)) {
        $fields['url'] = $url;
    }

    if (!empty($image)) {
        $fields['big_picture'] = $image;
    }

    $fields = json_encode($fields, JSON_UNESCAPED_UNICODE);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic ' . $restKey
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode == 200) {
        $message = "تم إرسال الإشعار بنجاح ✅";
        $messageType = "success";
    } else {
        $message = "فشل إرسال الإشعار ❌";
        $messageType = "error";
    }
}

// ==================== معالجة الأفلام ====================
// إضافة فيلم
if (isset($_POST['add_movie'])) {
    $title = $_POST['movie_title'];
    $description = $_POST['movie_description'];
    $poster = $_POST['movie_poster'];
    $video_url = $_POST['movie_video_url'];
    $duration = $_POST['movie_duration'];
    $release_year = intval($_POST['movie_release_year']);
    $genre = $_POST['movie_genre'];
    $rating = floatval($_POST['movie_rating']);
    $quality = $_POST['movie_quality'];
    $language = $_POST['movie_language'];

    $stmt = $conn->prepare("INSERT INTO movies (title, description, poster, video_url, duration, release_year, genre, rating, quality, language) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssssissss", $title, $description, $poster, $video_url, $duration, $release_year, $genre, $rating, $quality, $language);
    
    if ($stmt->execute()) {
        $message = "تم إضافة الفيلم بنجاح ✅";
        $messageType = "success";
    }
    $stmt->close();
}

// حذف فيلم
if (isset($_GET['delete_movie'])) {
    $id = intval($_GET['delete_movie']);
    $stmt = $conn->prepare("DELETE FROM movies WHERE id = ?");
    $stmt->bind_param("i", $id);
    
    if ($stmt->execute()) {
        $message = "تم حذف الفيلم بنجاح ✅";
        $messageType = "success";
    }
    $stmt->close();
}

// تعديل فيلم
if (isset($_POST['edit_movie'])) {
    $id = intval($_POST['movie_id']);
    $title = $_POST['movie_title'];
    $description = $_POST['movie_description'];
    $poster = $_POST['movie_poster'];
    $video_url = $_POST['movie_video_url'];
    $duration = $_POST['movie_duration'];
    $release_year = intval($_POST['movie_release_year']);
    $genre = $_POST['movie_genre'];
    $rating = floatval($_POST['movie_rating']);
    $quality = $_POST['movie_quality'];
    $language = $_POST['movie_language'];

    $stmt = $conn->prepare("UPDATE movies SET title=?, description=?, poster=?, video_url=?, duration=?, release_year=?, genre=?, rating=?, quality=?, language=? WHERE id=?");
    $stmt->bind_param("sssssissssi", $title, $description, $poster, $video_url, $duration, $release_year, $genre, $rating, $quality, $language, $id);
    
    if ($stmt->execute()) {
        $message = "تم تحديث الفيلم بنجاح ✅";
        $messageType = "success";
    }
    $stmt->close();
}

// جلب البيانات
$channels = $conn->query("SELECT * FROM channels ORDER BY id DESC");
$matches = $conn->query("SELECT * FROM live_matches ORDER BY match_time DESC");
$movies = $conn->query("SELECT * FROM movies ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة التحكم الاحترافية</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 20px;
        }

        .header {
            background: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 5px 25px rgba(0,0,0,0.2);
            margin-bottom: 30px;
            text-align: center;
        }

        .header h1 {
            color: #667eea;
            font-size: 2.5em;
            margin-bottom: 10px;
        }

        .header p {
            color: #666;
            font-size: 1.1em;
        }

        .tabs {
            display: flex;
            gap: 15px;
            margin-bottom: 30px;
            flex-wrap: wrap;
        }

        .tab-btn {
            flex: 1;
            min-width: 200px;
            padding: 18px 25px;
            background: white;
            border: none;
            border-radius: 12px;
            cursor: pointer;
            font-size: 1.1em;
            font-weight: bold;
            color: #667eea;
            transition: all 0.3s;
            box-shadow: 0 3px 15px rgba(0,0,0,0.1);
        }

        .tab-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.2);
        }

        .tab-btn.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .tab-content {
            display: none;
            animation: fadeIn 0.5s;
        }

        .tab-content.active {
            display: block;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .card {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 25px rgba(0,0,0,0.2);
            margin-bottom: 25px;
        }

        .card h2 {
            color: #667eea;
            margin-bottom: 20px;
            font-size: 1.8em;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 1em;
        }

        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 1em;
            transition: border 0.3s;
        }

        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: #667eea;
        }

        .form-group textarea {
            resize: vertical;
            min-height: 100px;
        }

        .form-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 15px;
        }

        .btn {
            padding: 14px 30px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1.1em;
            font-weight: bold;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        }

        .btn-danger {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
            padding: 8px 15px;
            font-size: 0.9em;
        }

        .btn-danger:hover {
            transform: scale(1.05);
        }

        .btn-edit {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            color: white;
            padding: 8px 15px;
            font-size: 0.9em;
        }

        .btn-edit:hover {
            transform: scale(1.05);
        }

        .table-container {
            overflow-x: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        table th {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px;
            text-align: right;
            font-size: 1.1em;
        }

        table td {
            padding: 12px;
            border-bottom: 1px solid #e0e0e0;
            text-align: right;
        }

        table tr:hover {
            background: #f5f5f5;
        }

        table img {
            width: 50px;
            height: 50px;
            object-fit: cover;
            border-radius: 8px;
        }

        .message {
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 1.1em;
            font-weight: bold;
            display: flex;
            align-items: center;
            gap: 10px;
            animation: slideIn 0.5s;
        }

        @keyframes slideIn {
            from { transform: translateX(100%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }

        .message.success {
            background: #d4edda;
            color: #155724;
            border: 2px solid #c3e6cb;
        }

        .message.error {
            background: #f8d7da;
            color: #721c24;
            border: 2px solid #f5c6cb;
        }

        .actions {
            display: flex;
            gap: 8px;
        }

        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.6);
            z-index: 1000;
            justify-content: center;
            align-items: center;
            animation: fadeIn 0.3s;
        }

        .modal.active {
            display: flex;
        }

        .modal-content {
            background: white;
            padding: 30px;
            border-radius: 15px;
            max-width: 600px;
            width: 90%;
            max-height: 90vh;
            overflow-y: auto;
            animation: slideUp 0.3s;
        }

        @keyframes slideUp {
            from { transform: translateY(50px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }

        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .modal-header h3 {
            color: #667eea;
            font-size: 1.5em;
        }

        .close-modal {
            background: none;
            border: none;
            font-size: 2em;
            cursor: pointer;
            color: #999;
        }

        .close-modal:hover {
            color: #333;
        }

        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 5px 25px rgba(0,0,0,0.1);
            text-align: center;
        }

        .stat-card i {
            font-size: 3em;
            color: #667eea;
            margin-bottom: 15px;
        }

        .stat-card h3 {
            font-size: 2.5em;
            color: #333;
            margin-bottom: 5px;
        }

        .stat-card p {
            color: #666;
            font-size: 1.1em;
        }

        @media (max-width: 768px) {
            .form-row {
                grid-template-columns: 1fr;
            }

            .tabs {
                flex-direction: column;
            }

            .tab-btn {
                width: 100%;
            }

            table {
                font-size: 0.9em;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><i class="fas fa-tools"></i> لوحة التحكم الاحترافية</h1>
            <p>إدارة القنوات والمباريات والإشعارات</p>
            <div style="margin-top: 15px;">
                <span style="color: #666;">مرحباً، <?= $_SESSION['admin_username'] ?></span>
                <a href="logout.php" style="color: #f5576c; margin-right: 15px; text-decoration: none; font-weight: bold;">
                    <i class="fas fa-sign-out-alt"></i> تسجيل الخروج
                </a>
            </div>
        </div>

        <?php if ($message): ?>
            <div class="message <?= $messageType ?>">
                <i class="fas fa-<?= $messageType === 'success' ? 'check-circle' : 'exclamation-circle' ?>"></i>
                <?= $message ?>
            </div>
        <?php endif; ?>

        <!-- إحصائيات -->
        <div class="stats">
            <div class="stat-card">
                <i class="fas fa-tv"></i>
                <h3><?= $channels->num_rows ?></h3>
                <p>إجمالي القنوات</p>
            </div>
            <div class="stat-card">
                <i class="fas fa-futbol"></i>
                <h3><?= $matches->num_rows ?></h3>
                <p>إجمالي المباريات</p>
            </div>
            <div class="stat-card">
                <i class="fas fa-film"></i>
                <h3><?= $movies->num_rows ?></h3>
                <p>إجمالي الأفلام</p>
            </div>
            <div class="stat-card">
                <i class="fas fa-bell"></i>
                <h3>OneSignal</h3>
                <p>نظام الإشعارات</p>
            </div>
        </div>

        <!-- التبويبات -->
        <div class="tabs">
            <button class="tab-btn active" onclick="showTab('channels')">
                <i class="fas fa-tv"></i> إدارة القنوات
            </button>
            <button class="tab-btn" onclick="showTab('matches')">
                <i class="fas fa-futbol"></i> إدارة المباريات
            </button>
            <button class="tab-btn" onclick="showTab('movies')">
                <i class="fas fa-film"></i> إدارة الأفلام
            </button>
            <button class="tab-btn" onclick="showTab('notifications')">
                <i class="fas fa-bell"></i> إرسال إشعارات
            </button>
        </div>

        <!-- تبويب القنوات -->
        <div id="channels" class="tab-content active">
            <div class="card">
                <h2><i class="fas fa-plus-circle"></i> إضافة قناة جديدة</h2>
                <form method="POST">
                    <div class="form-row">
                        <div class="form-group">
                            <label>اسم القناة</label>
                            <input type="text" name="ch_title" required placeholder="مثال: قناة الرياضة">
                        </div>
                        <div class="form-group">
                            <label>التصنيف</label>
                            <select name="ch_category" required>
                                <option value="رياضية">رياضية</option>
                                <option value="إخبارية">إخبارية</option>
                                <option value="ترفيهية">ترفيهية</option>
                                <option value="أطفال">أطفال</option>
                                <option value="أفلام">أفلام</option>
                                <option value="عامة">عامة</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>رابط البث</label>
                            <input type="url" name="ch_url" required placeholder="https://example.com/stream.m3u8">
                        </div>
                        <div class="form-group">
                            <label>رابط الصورة</label>
                            <input type="url" name="ch_pic" required placeholder="https://example.com/logo.png">
                        </div>
                    </div>
                    <button type="submit" name="add_channel" class="btn btn-primary">
                        <i class="fas fa-plus"></i> إضافة القناة
                    </button>
                </form>
            </div>

            <div class="card">
                <h2><i class="fas fa-list"></i> قائمة القنوات</h2>
                <div class="table-container">
                    <table>
                        <thead>
                            <tr>
                                <th>الرقم</th>
                                <th>الصورة</th>
                                <th>اسم القناة</th>
                                <th>التصنيف</th>
                                <th>رابط البث</th>
                                <th>تاريخ الإضافة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $channels->data_seek(0);
                            while ($ch = $channels->fetch_assoc()): 
                            ?>
                                <tr>
                                    <td><?= $ch['id'] ?></td>
                                    <td><img src="<?= $ch['pic'] ?>" alt="<?= $ch['title'] ?>"></td>
                                    <td><?= $ch['title'] ?></td>
                                    <td><?= $ch['category'] ?></td>
                                    <td><a href="<?= $ch['url'] ?>" target="_blank" style="color: #667eea;">عرض</a></td>
                                    <td><?= date('Y-m-d', strtotime($ch['created_at'])) ?></td>
                                    <td>
                                        <div class="actions">
                                            <button class="btn btn-edit" onclick="editChannel(<?= htmlspecialchars(json_encode($ch)) ?>)">
                                                <i class="fas fa-edit"></i> تعديل
                                            </button>
                                            <a href="?delete_channel=<?= $ch['id'] ?>" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من الحذف؟')">
                                                <i class="fas fa-trash"></i> حذف
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- تبويب المباريات -->
        <div id="matches" class="tab-content">
            <div class="card">
                <h2><i class="fas fa-plus-circle"></i> إضافة مباراة جديدة</h2>
                <form method="POST">
                    <div class="form-row">
                        <div class="form-group">
                            <label>الفريق الأول</label>
                            <input type="text" name="team1_name" required placeholder="مثال: برشلونة">
                        </div>
                        <div class="form-group">
                            <label>شعار الفريق الأول</label>
                            <input type="url" name="team1_logo" placeholder="رابط الشعار">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>الفريق الثاني</label>
                            <input type="text" name="team2_name" required placeholder="مثال: ريال مدريد">
                        </div>
                        <div class="form-group">
                            <label>شعار الفريق الثاني</label>
                            <input type="url" name="team2_logo" placeholder="رابط الشعار">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>وقت المباراة</label>
                            <input type="datetime-local" name="match_time" required>
                        </div>
                        <div class="form-group">
                            <label>حالة المباراة</label>
                            <select name="status" required>
                                <option value="لم تبدأ">لم تبدأ</option>
                                <option value="مباشر الآن">مباشر الآن</option>
                                <option value="انتهت">انتهت</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>القناة الناقلة</label>
                            <input type="text" name="channel" placeholder="مثال: beIN Sports HD1">
                        </div>
                        <div class="form-group">
                            <label>المعلق</label>
                            <input type="text" name="commentator" placeholder="مثال: عصام الشوالي">
                        </div>
                    </div>
                    <button type="submit" name="add_match" class="btn btn-primary">
                        <i class="fas fa-plus"></i> إضافة المباراة
                    </button>
                </form>
            </div>

            <div class="card">
                <h2><i class="fas fa-list"></i> قائمة المباريات</h2>
                <div class="table-container">
                    <table>
                        <thead>
                            <tr>
                                <th>الرقم</th>
                                <th>الفريق الأول</th>
                                <th>الفريق الثاني</th>
                                <th>وقت المباراة</th>
                                <th>الحالة</th>
                                <th>القناة</th>
                                <th>المعلق</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $matches->data_seek(0);
                            while ($match = $matches->fetch_assoc()): 
                            ?>
                                <tr>
                                    <td><?= $match['id'] ?></td>
                                    <td>
                                        <?php if ($match['team1_logo']): ?>
                                            <img src="<?= $match['team1_logo'] ?>" alt="<?= $match['team1_name'] ?>">
                                        <?php endif; ?>
                                        <?= $match['team1_name'] ?>
                                    </td>
                                    <td>
                                        <?php if ($match['team2_logo']): ?>
                                            <img src="<?= $match['team2_logo'] ?>" alt="<?= $match['team2_name'] ?>">
                                        <?php endif; ?>
                                        <?= $match['team2_name'] ?>
                                    </td>
                                    <td><?= date('Y-m-d H:i', strtotime($match['match_time'])) ?></td>
                                    <td><strong><?= $match['status'] ?></strong></td>
                                    <td><?= $match['channel'] ?></td>
                                    <td><?= $match['commentator'] ?></td>
                                    <td>
                                        <div class="actions">
                                            <button class="btn btn-edit" onclick="editMatch(<?= htmlspecialchars(json_encode($match)) ?>)">
                                                <i class="fas fa-edit"></i> تعديل
                                            </button>
                                            <a href="?delete_match=<?= $match['id'] ?>" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من الحذف؟')">
                                                <i class="fas fa-trash"></i> حذف
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- تبويب الأفلام -->
        <div id="movies" class="tab-content">
            <div class="card">
                <h2><i class="fas fa-plus-circle"></i> إضافة فيلم جديد</h2>
                <form method="POST">
                    <div class="form-row">
                        <div class="form-group">
                            <label>عنوان الفيلم</label>
                            <input type="text" name="movie_title" required placeholder="مثال: الرسالة">
                        </div>
                        <div class="form-group">
                            <label>التصنيف</label>
                            <select name="movie_genre" required>
                                <option value="أكشن">أكشن</option>
                                <option value="كوميديا">كوميديا</option>
                                <option value="دراما">دراما</option>
                                <option value="رومانسي">رومانسي</option>
                                <option value="رعب">رعب</option>
                                <option value="خيال علمي">خيال علمي</option>
                                <option value="إثارة">إثارة</option>
                                <option value="تاريخي">تاريخي</option>
                                <option value="وثائقي">وثائقي</option>
                                <option value="عائلي">عائلي</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>وصف الفيلم</label>
                        <textarea name="movie_description" placeholder="وصف مختصر للفيلم" rows="3"></textarea>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>رابط الملصق (Poster)</label>
                            <input type="url" name="movie_poster" required placeholder="https://example.com/poster.jpg">
                        </div>
                        <div class="form-group">
                            <label>رابط الفيديو</label>
                            <input type="url" name="movie_video_url" required placeholder="https://example.com/movie.mp4">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>المدة</label>
                            <input type="text" name="movie_duration" placeholder="مثال: 2:15:00">
                        </div>
                        <div class="form-group">
                            <label>سنة الإصدار</label>
                            <input type="number" name="movie_release_year" min="1900" max="2030" placeholder="2024">
                        </div>
                        <div class="form-group">
                            <label>التقييم</label>
                            <input type="number" name="movie_rating" step="0.1" min="0" max="10" placeholder="8.5">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>الجودة</label>
                            <select name="movie_quality">
                                <option value="HD">HD</option>
                                <option value="Full HD">Full HD</option>
                                <option value="4K">4K</option>
                                <option value="CAM">CAM</option>
                                <option value="DVD">DVD</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>اللغة</label>
                            <select name="movie_language">
                                <option value="عربي">عربي</option>
                                <option value="إنجليزي">إنجليزي</option>
                                <option value="مترجم">مترجم</option>
                                <option value="مدبلج">مدبلج</option>
                            </select>
                        </div>
                    </div>
                    <button type="submit" name="add_movie" class="btn btn-primary">
                        <i class="fas fa-plus"></i> إضافة الفيلم
                    </button>
                </form>
            </div>

            <div class="card">
                <h2><i class="fas fa-list"></i> قائمة الأفلام</h2>
                <div class="table-container">
                    <table>
                        <thead>
                            <tr>
                                <th>الرقم</th>
                                <th>الملصق</th>
                                <th>العنوان</th>
                                <th>التصنيف</th>
                                <th>السنة</th>
                                <th>التقييم</th>
                                <th>الجودة</th>
                                <th>المشاهدات</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $movies->data_seek(0);
                            while ($movie = $movies->fetch_assoc()): 
                            ?>
                                <tr>
                                    <td><?= $movie['id'] ?></td>
                                    <td><img src="<?= $movie['poster'] ?>" alt="<?= $movie['title'] ?>" style="width: 60px; height: 80px;"></td>
                                    <td><strong><?= $movie['title'] ?></strong></td>
                                    <td><?= $movie['genre'] ?></td>
                                    <td><?= $movie['release_year'] ?></td>
                                    <td><strong style="color: #f39c12;">⭐ <?= $movie['rating'] ?></strong></td>
                                    <td><?= $movie['quality'] ?></td>
                                    <td><?= number_format($movie['views']) ?></td>
                                    <td>
                                        <div class="actions">
                                            <button class="btn btn-edit" onclick="editMovie(<?= htmlspecialchars(json_encode($movie)) ?>)">
                                                <i class="fas fa-edit"></i> تعديل
                                            </button>
                                            <a href="?delete_movie=<?= $movie['id'] ?>" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذا الفيلم؟')">
                                                <i class="fas fa-trash"></i> حذف
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- تبويب الإشعارات -->
        <div id="notifications" class="tab-content">
            <div class="card">
                <h2><i class="fas fa-paper-plane"></i> إرسال إشعار لجميع المستخدمين</h2>
                <form method="POST">
                    <div class="form-group">
                        <label>عنوان الإشعار</label>
                        <input type="text" name="notif_title" required placeholder="أدخل عنوان الإشعار">
                    </div>
                    <div class="form-group">
                        <label>محتوى الإشعار</label>
                        <textarea name="notif_message" required placeholder="أدخل محتوى الإشعار"></textarea>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>رابط عند الضغط (اختياري)</label>
                            <input type="url" name="notif_url" placeholder="https://example.com">
                        </div>
                        <div class="form-group">
                            <label>رابط الصورة (اختياري)</label>
                            <input type="url" name="notif_image" placeholder="https://example.com/image.jpg">
                        </div>
                    </div>
                    <button type="submit" name="send_notification" class="btn btn-primary">
                        <i class="fas fa-paper-plane"></i> إرسال الإشعار
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal لتعديل القناة -->
    <div id="editChannelModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3><i class="fas fa-edit"></i> تعديل القناة</h3>
                <button class="close-modal" onclick="closeModal('editChannelModal')">&times;</button>
            </div>
            <form method="POST">
                <input type="hidden" name="ch_id" id="edit_ch_id">
                <div class="form-group">
                    <label>اسم القناة</label>
                    <input type="text" name="ch_title" id="edit_ch_title" required>
                </div>
                <div class="form-group">
                    <label>التصنيف</label>
                    <select name="ch_category" id="edit_ch_category" required>
                        <option value="رياضية">رياضية</option>
                        <option value="إخبارية">إخبارية</option>
                        <option value="ترفيهية">ترفيهية</option>
                        <option value="أطفال">أطفال</option>
                        <option value="أفلام">أفلام</option>
                        <option value="عامة">عامة</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>رابط البث</label>
                    <input type="url" name="ch_url" id="edit_ch_url" required>
                </div>
                <div class="form-group">
                    <label>رابط الصورة</label>
                    <input type="url" name="ch_pic" id="edit_ch_pic" required>
                </div>
                <button type="submit" name="edit_channel" class="btn btn-primary">
                    <i class="fas fa-save"></i> حفظ التغييرات
                </button>
            </form>
        </div>
    </div>

    <!-- Modal لتعديل الفيلم -->
    <div id="editMovieModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3><i class="fas fa-edit"></i> تعديل الفيلم</h3>
                <button class="close-modal" onclick="closeModal('editMovieModal')">&times;</button>
            </div>
            <form method="POST">
                <input type="hidden" name="movie_id" id="edit_movie_id">
                <div class="form-group">
                    <label>عنوان الفيلم</label>
                    <input type="text" name="movie_title" id="edit_movie_title" required>
                </div>
                <div class="form-group">
                    <label>التصنيف</label>
                    <select name="movie_genre" id="edit_movie_genre" required>
                        <option value="أكشن">أكشن</option>
                        <option value="كوميديا">كوميديا</option>
                        <option value="دراما">دراما</option>
                        <option value="رومانسي">رومانسي</option>
                        <option value="رعب">رعب</option>
                        <option value="خيال علمي">خيال علمي</option>
                        <option value="إثارة">إثارة</option>
                        <option value="تاريخي">تاريخي</option>
                        <option value="وثائقي">وثائقي</option>
                        <option value="عائلي">عائلي</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>وصف الفيلم</label>
                    <textarea name="movie_description" id="edit_movie_description" rows="3"></textarea>
                </div>
                <div class="form-group">
                    <label>رابط الملصق</label>
                    <input type="url" name="movie_poster" id="edit_movie_poster" required>
                </div>
                <div class="form-group">
                    <label>رابط الفيديو</label>
                    <input type="url" name="movie_video_url" id="edit_movie_video_url" required>
                </div>
                <div class="form-group">
                    <label>المدة</label>
                    <input type="text" name="movie_duration" id="edit_movie_duration">
                </div>
                <div class="form-group">
                    <label>سنة الإصدار</label>
                    <input type="number" name="movie_release_year" id="edit_movie_release_year">
                </div>
                <div class="form-group">
                    <label>التقييم</label>
                    <input type="number" name="movie_rating" id="edit_movie_rating" step="0.1" min="0" max="10">
                </div>
                <div class="form-group">
                    <label>الجودة</label>
                    <select name="movie_quality" id="edit_movie_quality">
                        <option value="HD">HD</option>
                        <option value="Full HD">Full HD</option>
                        <option value="4K">4K</option>
                        <option value="CAM">CAM</option>
                        <option value="DVD">DVD</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>اللغة</label>
                    <select name="movie_language" id="edit_movie_language">
                        <option value="عربي">عربي</option>
                        <option value="إنجليزي">إنجليزي</option>
                        <option value="مترجم">مترجم</option>
                        <option value="مدبلج">مدبلج</option>
                    </select>
                </div>
                <button type="submit" name="edit_movie" class="btn btn-primary">
                    <i class="fas fa-save"></i> حفظ التغييرات
                </button>
            </form>
        </div>
    </div>

    <!-- Modal لتعديل المباراة -->
    <div id="editMatchModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3><i class="fas fa-edit"></i> تعديل المباراة</h3>
                <button class="close-modal" onclick="closeModal('editMatchModal')">&times;</button>
            </div>
            <form method="POST">
                <input type="hidden" name="match_id" id="edit_match_id">
                <div class="form-group">
                    <label>الفريق الأول</label>
                    <input type="text" name="team1_name" id="edit_team1_name" required>
                </div>
                <div class="form-group">
                    <label>شعار الفريق الأول</label>
                    <input type="url" name="team1_logo" id="edit_team1_logo">
                </div>
                <div class="form-group">
                    <label>الفريق الثاني</label>
                    <input type="text" name="team2_name" id="edit_team2_name" required>
                </div>
                <div class="form-group">
                    <label>شعار الفريق الثاني</label>
                    <input type="url" name="team2_logo" id="edit_team2_logo">
                </div>
                <div class="form-group">
                    <label>وقت المباراة</label>
                    <input type="datetime-local" name="match_time" id="edit_match_time" required>
                </div>
                <div class="form-group">
                    <label>حالة المباراة</label>
                    <select name="status" id="edit_status" required>
                        <option value="لم تبدأ">لم تبدأ</option>
                        <option value="مباشر الآن">مباشر الآن</option>
                        <option value="انتهت">انتهت</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>القناة الناقلة</label>
                    <input type="text" name="channel" id="edit_channel">
                </div>
                <div class="form-group">
                    <label>المعلق</label>
                    <input type="text" name="commentator" id="edit_commentator">
                </div>
                <button type="submit" name="edit_match" class="btn btn-primary">
                    <i class="fas fa-save"></i> حفظ التغييرات
                </button>
            </form>
        </div>
    </div>

    <script>
        function showTab(tabName) {
            // إخفاء جميع التبويبات
            document.querySelectorAll('.tab-content').forEach(tab => {
                tab.classList.remove('active');
            });
            document.querySelectorAll('.tab-btn').forEach(btn => {
                btn.classList.remove('active');
            });

            // إظهار التبويب المحدد
            document.getElementById(tabName).classList.add('active');
            event.target.classList.add('active');
        }

        function editChannel(channel) {
            document.getElementById('edit_ch_id').value = channel.id;
            document.getElementById('edit_ch_title').value = channel.title;
            document.getElementById('edit_ch_url').value = channel.url;
            document.getElementById('edit_ch_pic').value = channel.pic;
            document.getElementById('edit_ch_category').value = channel.category;
            document.getElementById('editChannelModal').classList.add('active');
        }

        function editMatch(match) {
            document.getElementById('edit_match_id').value = match.id;
            document.getElementById('edit_team1_name').value = match.team1_name;
            document.getElementById('edit_team1_logo').value = match.team1_logo;
            document.getElementById('edit_team2_name').value = match.team2_name;
            document.getElementById('edit_team2_logo').value = match.team2_logo;
            document.getElementById('edit_match_time').value = match.match_time.replace(' ', 'T').slice(0, 16);
            document.getElementById('edit_status').value = match.status;
            document.getElementById('edit_channel').value = match.channel;
            document.getElementById('edit_commentator').value = match.commentator;
            document.getElementById('editMatchModal').classList.add('active');
        }

        function editMovie(movie) {
            document.getElementById('edit_movie_id').value = movie.id;
            document.getElementById('edit_movie_title').value = movie.title;
            document.getElementById('edit_movie_genre').value = movie.genre;
            document.getElementById('edit_movie_description').value = movie.description;
            document.getElementById('edit_movie_poster').value = movie.poster;
            document.getElementById('edit_movie_video_url').value = movie.video_url;
            document.getElementById('edit_movie_duration').value = movie.duration;
            document.getElementById('edit_movie_release_year').value = movie.release_year;
            document.getElementById('edit_movie_rating').value = movie.rating;
            document.getElementById('edit_movie_quality').value = movie.quality;
            document.getElementById('edit_movie_language').value = movie.language;
            document.getElementById('editMovieModal').classList.add('active');
        }

        function closeModal(modalId) {
            document.getElementById(modalId).classList.remove('active');
        }

        // إغلاق النافذة عند النقر خارجها
        window.onclick = function(event) {
            if (event.target.classList.contains('modal')) {
                event.target.classList.remove('active');
            }
        }

        // إخفاء الرسالة بعد 5 ثوانٍ
        setTimeout(function() {
            const message = document.querySelector('.message');
            if (message) {
                message.style.animation = 'slideIn 0.5s reverse';
                setTimeout(() => message.remove(), 500);
            }
        }, 5000);
    </script>
</body>
</html>
