<?php
// Entry point: load config, route requests, load controllers
$config = require __DIR__ . '/../config.php';
require_once __DIR__ . '/../app/Database.php';

// Simple router (for demonstration)

$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = str_replace(['\\', '/'], DIRECTORY_SEPARATOR, $uri);
$uri = trim($uri, DIRECTORY_SEPARATOR);

// Remove base path if present (e.g., saas/public or saas)
$base = basename(dirname(__DIR__)); // 'saas'
if (strpos($uri, $base . DIRECTORY_SEPARATOR . 'public') === 0) {
    $uri = substr($uri, strlen($base . DIRECTORY_SEPARATOR . 'public'));
} elseif (strpos($uri, $base) === 0) {
    $uri = substr($uri, strlen($base));
}
$uri = trim($uri, DIRECTORY_SEPARATOR);

if ($uri === '' || $uri === 'index.php') {
    require __DIR__ . '/../controllers/DashboardController.php';
} elseif ($uri === 'dashboard') {
    require __DIR__ . '/../controllers/DashboardController.php';
} elseif ($uri === 'inventory') {
    require __DIR__ . '/../controllers/InventoryController.php';
} elseif ($uri === 'customers') {
    require __DIR__ . '/../controllers/CustomerController.php';
} elseif ($uri === 'categories') {
    require __DIR__ . '/../controllers/CategoryController.php';
} elseif ($uri === 'suppliers') {
    require __DIR__ . '/../controllers/SupplierController.php';
} elseif ($uri === 'users') {
    require __DIR__ . '/../controllers/UserController.php';
} elseif ($uri === 'settings') {
    require __DIR__ . '/../controllers/SettingsController.php';
} elseif ($uri === 'login') {
    require __DIR__ . '/../controllers/AuthController.php';
} else {
    http_response_code(404);
    echo '404 Not Found';
}
