<?php
class User {
    private $db;
    public function __construct($pdo) {
        $this->db = $pdo;
    }
    public function findByUsername($username) {
        $stmt = $this->db->prepare('SELECT * FROM users WHERE username = ?');
        $stmt->execute([$username]);
        return $stmt->fetch();
    }
    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO users (fullName, username, password, role) VALUES (?, ?, ?, ?)');
        $stmt->execute([
            $data['fullName'], $data['username'], password_hash($data['password'], PASSWORD_DEFAULT), $data['role']
        ]);
        return $this->db->lastInsertId();
    }
    public function all() {
        $stmt = $this->db->query('SELECT id, fullName, username, role FROM users');
        return $stmt->fetchAll();
    }
}
