<?php
class Supplier {
    private $db;
    public function __construct($pdo) {
        $this->db = $pdo;
    }
    public function all() {
        $stmt = $this->db->query('SELECT * FROM suppliers');
        return $stmt->fetchAll();
    }
    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO suppliers (name, contactPerson, phone) VALUES (?, ?, ?)');
        $stmt->execute([
            $data['name'], $data['contactPerson'], $data['phone']
        ]);
        return $this->db->lastInsertId();
    }
    public function delete($id) {
        $stmt = $this->db->prepare('DELETE FROM suppliers WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
