<?php
class Product {
    private $db;
    public function __construct($pdo) {
        $this->db = $pdo;
    }
    public function all() {
        $stmt = $this->db->query('SELECT * FROM products');
        return $stmt->fetchAll();
    }
    public function find($id) {
        $stmt = $this->db->prepare('SELECT * FROM products WHERE id = ?');
        $stmt->execute([$id]);
        return $stmt->fetch();
    }
    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO products (name, barcode, category, price, cost, stock, minStock, supplierId) VALUES (?, ?, ?, ?, ?, ?, ?, ?)');
        $stmt->execute([
            $data['name'], $data['barcode'], $data['category'], $data['price'], $data['cost'], $data['stock'], $data['minStock'], $data['supplierId']
        ]);
        return $this->db->lastInsertId();
    }
    public function update($id, $data) {
        $stmt = $this->db->prepare('UPDATE products SET name=?, barcode=?, category=?, price=?, cost=?, stock=?, minStock=?, supplierId=? WHERE id=?');
        return $stmt->execute([
            $data['name'], $data['barcode'], $data['category'], $data['price'], $data['cost'], $data['stock'], $data['minStock'], $data['supplierId'], $id
        ]);
    }
    public function delete($id) {
        $stmt = $this->db->prepare('DELETE FROM products WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
