<?php
class Invoice {
    private $db;
    public function __construct($pdo) {
        $this->db = $pdo;
    }
    public function all() {
        $stmt = $this->db->query('SELECT * FROM invoices');
        return $stmt->fetchAll();
    }
    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO invoices (customerName, date, timestamp, totalAmount, discount, finalAmount) VALUES (?, ?, ?, ?, ?, ?)');
        $stmt->execute([
            $data['customerName'], $data['date'], $data['timestamp'], $data['totalAmount'], $data['discount'], $data['finalAmount']
        ]);
        $invoiceId = $this->db->lastInsertId();
        // Insert items
        foreach ($data['items'] as $item) {
            $stmt2 = $this->db->prepare('INSERT INTO invoice_items (invoice_id, product_id, name, price, quantity) VALUES (?, ?, ?, ?, ?)');
            $stmt2->execute([$invoiceId, $item['id'], $item['name'], $item['price'], $item['quantity']]);
        }
        return $invoiceId;
    }
    public function find($id) {
        $stmt = $this->db->prepare('SELECT * FROM invoices WHERE id = ?');
        $stmt->execute([$id]);
        $invoice = $stmt->fetch();
        if ($invoice) {
            $stmt2 = $this->db->prepare('SELECT * FROM invoice_items WHERE invoice_id = ?');
            $stmt2->execute([$id]);
            $invoice['items'] = $stmt2->fetchAll();
        }
        return $invoice;
    }
}
