<?php
class Customer {
    private $db;
    public function __construct($pdo) {
        $this->db = $pdo;
    }
    public function all() {
        $stmt = $this->db->query('SELECT * FROM customers');
        return $stmt->fetchAll();
    }
    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO customers (name, phone, email) VALUES (?, ?, ?)');
        $stmt->execute([
            $data['name'], $data['phone'], $data['email']
        ]);
        return $this->db->lastInsertId();
    }
    public function delete($id) {
        $stmt = $this->db->prepare('DELETE FROM customers WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
