<?php
class Category {
    private $db;
    public function __construct($pdo) {
        $this->db = $pdo;
    }
    public function all() {
        $stmt = $this->db->query('SELECT * FROM categories');
        return $stmt->fetchAll();
    }
    public function create($data) {
        $stmt = $this->db->prepare('INSERT INTO categories (name, description) VALUES (?, ?)');
        $stmt->execute([
            $data['name'], $data['description']
        ]);
        return $this->db->lastInsertId();
    }
    public function delete($id) {
        $stmt = $this->db->prepare('DELETE FROM categories WHERE id = ?');
        return $stmt->execute([$id]);
    }
}
