<?php
// models/StreamSource.php
class StreamSource {
    private $conn;
    private $table_name = "stream_sources";

    public function __construct($db) {
        $this->conn = $db;
    }

    public function getByMatchId($match_id) {
        $query = "SELECT * FROM " . $this->table_name . "
                WHERE match_id = :match_id AND is_available = 1
                ORDER BY display_order ASC";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":match_id", $match_id);
        $stmt->execute();
        return $stmt;
    }

    public function create($data) {
        $query = "INSERT INTO " . $this->table_name . "
                (match_id, name, url, quality, stream_type, is_available, display_order)
                VALUES
                (:match_id, :name, :url, :quality, :stream_type, :is_available, :display_order)";

        $stmt = $this->conn->prepare($query);

        $stmt->bindParam(":match_id", $data['match_id']);
        $stmt->bindParam(":name", $data['name']);
        $stmt->bindParam(":url", $data['url']);
        $stmt->bindParam(":quality", $data['quality']);
        $stmt->bindParam(":stream_type", $data['stream_type']);
        $stmt->bindParam(":is_available", $data['is_available']);
        $stmt->bindParam(":display_order", $data['display_order']);

        return $stmt->execute();
    }

    public function update($id, $data) {
        $query = "UPDATE " . $this->table_name . "
                SET name = :name,
                    url = :url,
                    quality = :quality,
                    stream_type = :stream_type,
                    is_available = :is_available,
                    display_order = :display_order
                WHERE id = :id";

        $stmt = $this->conn->prepare($query);

        $stmt->bindParam(":id", $id);
        $stmt->bindParam(":name", $data['name']);
        $stmt->bindParam(":url", $data['url']);
        $stmt->bindParam(":quality", $data['quality']);
        $stmt->bindParam(":stream_type", $data['stream_type']);
        $stmt->bindParam(":is_available", $data['is_available']);
        $stmt->bindParam(":display_order", $data['display_order']);

        return $stmt->execute();
    }

    public function delete($id) {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = :id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":id", $id);
        return $stmt->execute();
    }
}
?>

