<?php
// models/Match.php
class MatchModel {
    private $conn;
    private $table_name = "matches";

    public function __construct($db) {
        $this->conn = $db;
    }

    // الحصول على جميع المباريات
    public function getAll($status = null, $limit = 50, $offset = 0) {
        $query = "SELECT
                    m.*,
                    l.name_ar as league_name,
                    ht.name_ar as home_team,
                    ht.logo_url as home_team_logo,
                    at.name_ar as away_team,
                    at.logo_url as away_team_logo
                FROM " . $this->table_name . " m
                LEFT JOIN leagues l ON m.league_id = l.id
                LEFT JOIN teams ht ON m.home_team_id = ht.id
                LEFT JOIN teams at ON m.away_team_id = at.id";

        if ($status) {
            $query .= " WHERE m.status = :status";
        }

        $query .= " ORDER BY m.match_time DESC LIMIT :limit OFFSET :offset";

        $stmt = $this->conn->prepare($query);

        if ($status) {
            $stmt->bindParam(":status", $status);
        }
        $stmt->bindParam(":limit", $limit, PDO::PARAM_INT);
        $stmt->bindParam(":offset", $offset, PDO::PARAM_INT);

        $stmt->execute();
        return $stmt;
    }

    // الحصول على مباراة واحدة
    public function getById($id) {
        $query = "SELECT
                    m.*,
                    l.name_ar as league_name,
                    ht.name_ar as home_team,
                    ht.logo_url as home_team_logo,
                    at.name_ar as away_team,
                    at.logo_url as away_team_logo
                FROM " . $this->table_name . " m
                LEFT JOIN leagues l ON m.league_id = l.id
                LEFT JOIN teams ht ON m.home_team_id = ht.id
                LEFT JOIN teams at ON m.away_team_id = at.id
                WHERE m.id = :id";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":id", $id);
        $stmt->execute();

        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    // إنشاء مباراة جديدة
    public function create($data) {
        $query = "INSERT INTO " . $this->table_name . "
                (league_id, home_team_id, away_team_id, home_score, away_score,
                status, match_time, current_minute, stadium, referee)
                VALUES
                (:league_id, :home_team_id, :away_team_id, :home_score, :away_score,
                :status, :match_time, :current_minute, :stadium, :referee)";

        $stmt = $this->conn->prepare($query);

        $stmt->bindParam(":league_id", $data['league_id']);
        $stmt->bindParam(":home_team_id", $data['home_team_id']);
        $stmt->bindParam(":away_team_id", $data['away_team_id']);
        $stmt->bindParam(":home_score", $data['home_score']);
        $stmt->bindParam(":away_score", $data['away_score']);
        $stmt->bindParam(":status", $data['status']);
        $stmt->bindParam(":match_time", $data['match_time']);
        $stmt->bindParam(":current_minute", $data['current_minute']);
        $stmt->bindParam(":stadium", $data['stadium']);
        $stmt->bindParam(":referee", $data['referee']);

        if($stmt->execute()) {
            return $this->conn->lastInsertId();
        }
        return false;
    }

    // تحديث مباراة
    public function update($id, $data) {
        $query = "UPDATE " . $this->table_name . "
                SET league_id = :league_id,
                    home_team_id = :home_team_id,
                    away_team_id = :away_team_id,
                    home_score = :home_score,
                    away_score = :away_score,
                    status = :status,
                    match_time = :match_time,
                    current_minute = :current_minute,
                    stadium = :stadium,
                    referee = :referee
                WHERE id = :id";

        $stmt = $this->conn->prepare($query);

        $stmt->bindParam(":id", $id);
        $stmt->bindParam(":league_id", $data['league_id']);
        $stmt->bindParam(":home_team_id", $data['home_team_id']);
        $stmt->bindParam(":away_team_id", $data['away_team_id']);
        $stmt->bindParam(":home_score", $data['home_score']);
        $stmt->bindParam(":away_score", $data['away_score']);
        $stmt->bindParam(":status", $data['status']);
        $stmt->bindParam(":match_time", $data['match_time']);
        $stmt->bindParam(":current_minute", $data['current_minute']);
        $stmt->bindParam(":stadium", $data['stadium']);
        $stmt->bindParam(":referee", $data['referee']);

        return $stmt->execute();
    }

    // حذف مباراة
    public function delete($id) {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = :id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":id", $id);
        return $stmt->execute();
    }

    // الحصول على أحداث المباراة
    public function getEvents($match_id) {
        $query = "SELECT * FROM match_events WHERE match_id = :match_id ORDER BY minute ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":match_id", $match_id);
        $stmt->execute();
        return $stmt;
    }

    // إضافة حدث للمباراة
    public function addEvent($match_id, $data) {
        $query = "INSERT INTO match_events
                (match_id, event_type, team_side, minute, player_name, assist_player_name, details)
                VALUES
                (:match_id, :event_type, :team_side, :minute, :player_name, :assist_player_name, :details)";

        $stmt = $this->conn->prepare($query);

        $stmt->bindParam(":match_id", $match_id);
        $stmt->bindParam(":event_type", $data['event_type']);
        $stmt->bindParam(":team_side", $data['team_side']);
        $stmt->bindParam(":minute", $data['minute']);
        $stmt->bindParam(":player_name", $data['player_name']);
        $stmt->bindParam(":assist_player_name", $data['assist_player_name']);
        $stmt->bindParam(":details", $data['details']);

        return $stmt->execute();
    }

    // الحصول على مصادر البث
    public function getStreamSources($match_id) {
        $query = "SELECT * FROM stream_sources
                WHERE match_id = :match_id AND is_available = 1
                ORDER BY display_order ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":match_id", $match_id);
        $stmt->execute();
        return $stmt;
    }
}
?>

