<?php
// api/matches/read.php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");

include_once '../config/database.php';
include_once '../models/Match.php';

$database = new Database();
$db = $database->getConnection();
$match = new MatchModel($db);

// الحصول على المعاملات
$status = isset($_GET['status']) ? $_GET['status'] : null;
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 50;
$offset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;

$stmt = $match->getAll($status, $limit, $offset);
$num = $stmt->rowCount();

if($num > 0) {
    $matches_arr = array();
    $matches_arr["success"] = true;
    $matches_arr["count"] = $num;
    $matches_arr["data"] = array();

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        extract($row);

        // الحصول على الأحداث
        $events_stmt = $match->getEvents($id);
        $events = array();
        while ($event = $events_stmt->fetch(PDO::FETCH_ASSOC)) {
            $events[] = array(
                "type" => $event['event_type'],
                "team" => $event['team_side'],
                "minute" => intval($event['minute']),
                "player" => $event['player_name'],
                "assistPlayer" => $event['assist_player_name']
            );
        }

        // الحصول على مصادر البث
        $streams_stmt = $match->getStreamSources($id);
        $streams = array();
        while ($stream = $streams_stmt->fetch(PDO::FETCH_ASSOC)) {
            $streams[] = array(
                "id" => $stream['id'],
                "name" => $stream['name'],
                "url" => $stream['url'],
                "quality" => $stream['quality'],
                "type" => $stream['stream_type'],
                "isAvailable" => (bool)$stream['is_available']
            );
        }

        $match_item = array(
            "id" => $id,
            "homeTeam" => $home_team,
            "awayTeam" => $away_team,
            "homeScore" => intval($home_score),
            "awayScore" => intval($away_score),
            "status" => $status,
            "league" => $league_name,
            "matchTime" => $match_time,
            "currentMinute" => $current_minute ? intval($current_minute) : null,
            "homeTeamLogo" => $home_team_logo,
            "awayTeamLogo" => $away_team_logo,
            "stadium" => $stadium,
            "referee" => $referee,
            "events" => $events,
            "streamSources" => $streams
        );

        array_push($matches_arr["data"], $match_item);
    }

    echo json_encode($matches_arr, JSON_UNESCAPED_UNICODE);
} else {
    echo json_encode(array(
        "success" => false,
        "message" => "لا توجد مباريات"
    ), JSON_UNESCAPED_UNICODE);
}
?>

