-- football_app Database Schema
-- إنشاء قاعدة البيانات

CREATE DATABASE IF NOT EXISTS football_app CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE football_app;

-- جدول المستخدمين
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    full_name VARCHAR(100),
    role ENUM('admin', 'moderator', 'user') DEFAULT 'user',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- جدول الدوريات
CREATE TABLE IF NOT EXISTS leagues (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    name_ar VARCHAR(100) NOT NULL,
    country VARCHAR(50),
    logo_url VARCHAR(255),
    is_active BOOLEAN DEFAULT TRUE,
    display_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- جدول الفرق
CREATE TABLE IF NOT EXISTS teams (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    name_ar VARCHAR(100) NOT NULL,
    logo_url VARCHAR(255),
    stadium VARCHAR(100),
    founded_year INT,
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- جدول المباريات
CREATE TABLE IF NOT EXISTS matches (
    id INT AUTO_INCREMENT PRIMARY KEY,
    league_id INT NOT NULL,
    home_team_id INT NOT NULL,
    away_team_id INT NOT NULL,
    home_score INT DEFAULT 0,
    away_score INT DEFAULT 0,
    status ENUM('upcoming', 'live', 'finished', 'postponed', 'cancelled') DEFAULT 'upcoming',
    match_time DATETIME NOT NULL,
    current_minute INT,
    stadium VARCHAR(100),
    referee VARCHAR(100),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (league_id) REFERENCES leagues(id) ON DELETE CASCADE,
    FOREIGN KEY (home_team_id) REFERENCES teams(id) ON DELETE CASCADE,
    FOREIGN KEY (away_team_id) REFERENCES teams(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- جدول أحداث المباراة
CREATE TABLE IF NOT EXISTS match_events (
    id INT AUTO_INCREMENT PRIMARY KEY,
    match_id INT NOT NULL,
    event_type ENUM('goal', 'yellowCard', 'redCard', 'substitution', 'penalty') NOT NULL,
    team_side ENUM('home', 'away') NOT NULL,
    minute INT NOT NULL,
    player_name VARCHAR(100) NOT NULL,
    assist_player_name VARCHAR(100),
    details TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (match_id) REFERENCES matches(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- جدول مصادر البث
CREATE TABLE IF NOT EXISTS stream_sources (
    id INT AUTO_INCREMENT PRIMARY KEY,
    match_id INT NOT NULL,
    name VARCHAR(100) NOT NULL,
    url TEXT NOT NULL,
    quality ENUM('SD', 'HD', 'FHD', '4K', 'Auto') DEFAULT 'Auto',
    stream_type ENUM('m3u8', 'm3u', 'mpd', 'mp4', 'ts', 'flv') DEFAULT 'm3u8',
    is_available BOOLEAN DEFAULT TRUE,
    display_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (match_id) REFERENCES matches(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- جدول الإحصائيات
CREATE TABLE IF NOT EXISTS match_statistics (
    id INT AUTO_INCREMENT PRIMARY KEY,
    match_id INT NOT NULL,
    team_side ENUM('home', 'away') NOT NULL,
    possession INT DEFAULT 0,
    shots INT DEFAULT 0,
    shots_on_target INT DEFAULT 0,
    corners INT DEFAULT 0,
    fouls INT DEFAULT 0,
    offsides INT DEFAULT 0,
    yellow_cards INT DEFAULT 0,
    red_cards INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (match_id) REFERENCES matches(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- جدول الإعدادات
CREATE TABLE IF NOT EXISTS settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    setting_key VARCHAR(50) UNIQUE NOT NULL,
    setting_value TEXT,
    setting_type VARCHAR(20) DEFAULT 'text',
    description VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إدراج بيانات تجريبية

-- مستخدم افتراضي (admin/admin123)
INSERT INTO users (username, password, email, full_name, role) VALUES
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin@footballapp.com', 'المدير العام', 'admin');

-- دوريات تجريبية
INSERT INTO leagues (name, name_ar, country, is_active, display_order) VALUES
('Saudi Pro League', 'دوري روشن السعودي', 'Saudi Arabia', TRUE, 1),
('English Premier League', 'الدوري الإنجليزي الممتاز', 'England', TRUE, 2),
('La Liga', 'الدوري الإسباني', 'Spain', TRUE, 3),
('Bundesliga', 'الدوري الألماني', 'Germany', TRUE, 4),
('Serie A', 'الدوري الإيطالي', 'Italy', TRUE, 5),
('Ligue 1', 'الدوري الفرنسي', 'France', TRUE, 6);

-- فرق تجريبية
INSERT INTO teams (name, name_ar, stadium, is_active) VALUES
('Al Hilal', 'الهلال', 'ملعب الملك فهد الدولي', TRUE),
('Al Nassr', 'النصر', 'ملعب مرسول بارك', TRUE),
('Al Ittihad', 'الاتحاد', 'ملعب الملك عبدالله الرياضية', TRUE),
('Al Ahli', 'الأهلي', 'ملعب الملك عبدالله الرياضية', TRUE),
('Real Madrid', 'ريال مدريد', 'سانتياغو برنابيو', TRUE),
('Barcelona', 'برشلونة', 'كامب نو', TRUE),
('Manchester City', 'مانشستر سيتي', 'الاتحاد', TRUE),
('Liverpool', 'ليفربول', 'أنفيلد', TRUE);

-- إعدادات افتراضية
INSERT INTO settings (setting_key, setting_value, setting_type, description) VALUES
('app_name', 'تطبيق مباريات كرة القدم', 'text', 'اسم التطبيق'),
('app_version', '1.0.0', 'text', 'إصدار التطبيق'),
('maintenance_mode', '0', 'boolean', 'وضع الصيانة'),
('api_rate_limit', '100', 'number', 'حد طلبات API في الدقيقة'),
('default_stream_quality', 'HD', 'text', 'الجودة الافتراضية للبث');

