<?php
/**
 * ملف الإعدادات - نسخة احتياطية
 *
 * انسخ هذا الملف إلى config/database.php
 * وعدّل البيانات حسب خادمك
 */

class Database {
    // إعدادات قاعدة البيانات
    private $host = "localhost";           // عنوان الخادم
    private $db_name = "football_app";     // اسم قاعدة البيانات
    private $username = "root";            // اسم المستخدم
    private $password = "";                // كلمة المرور (فارغة في XAMPP)
    public $conn;

    // دالة الاتصال
    public function getConnection() {
        $this->conn = null;

        try {
            $this->conn = new PDO(
                "mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=utf8mb4",
                $this->username,
                $this->password
            );
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->conn->exec("set names utf8mb4");
        } catch(PDOException $exception) {
            // في حالة الإنتاج، لا تعرض تفاصيل الخطأ
            // echo "خطأ في الاتصال: " . $exception->getMessage();

            // بدلاً من ذلك، سجل الخطأ في ملف
            error_log("Database Connection Error: " . $exception->getMessage());

            // أظهر رسالة عامة للمستخدم
            die("عذراً، حدث خطأ في الاتصال بقاعدة البيانات. يرجى المحاولة لاحقاً.");
        }

        return $this->conn;
    }
}

/**
 * للإنتاج (Production):
 *
 * 1. غيّر بيانات الاتصال
 * 2. عطّل عرض الأخطاء:
 *    ini_set('display_errors', 0);
 * 3. فعّل تسجيل الأخطاء:
 *    ini_set('log_errors', 1);
 *    ini_set('error_log', '/path/to/error.log');
 * 4. استخدم HTTPS فقط
 * 5. قيّد CORS Headers
 */
?>

