<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

include_once '../config/database.php';
include_once '../models/Match.php';

$database = new Database();
$db = $database->getConnection();
$match = new MatchModel($db);

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['action'])) {
        if ($_POST['action'] == 'create') {
            $data = [
                'league_id' => $_POST['league_id'],
                'home_team_id' => $_POST['home_team_id'],
                'away_team_id' => $_POST['away_team_id'],
                'home_score' => $_POST['home_score'] ?? 0,
                'away_score' => $_POST['away_score'] ?? 0,
                'status' => $_POST['status'],
                'match_time' => $_POST['match_time'],
                'current_minute' => $_POST['current_minute'] ?? null,
                'stadium' => $_POST['stadium'] ?? null,
                'referee' => $_POST['referee'] ?? null
            ];

            if ($match->create($data)) {
                $success = "تم إضافة المباراة بنجاح";
            } else {
                $error = "حدث خطأ أثناء إضافة المباراة";
            }
        } elseif ($_POST['action'] == 'delete') {
            if ($match->delete($_POST['id'])) {
                $success = "تم حذف المباراة بنجاح";
            }
        }
    }
}

// Get all matches
$stmt = $match->getAll(null, 100, 0);
$matches = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get leagues and teams for dropdown
$leagues = $db->query("SELECT id, name_ar FROM leagues WHERE is_active = 1")->fetchAll(PDO::FETCH_ASSOC);
$teams = $db->query("SELECT id, name_ar FROM teams WHERE is_active = 1")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة المباريات</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Cairo', sans-serif; }
    </style>
</head>
<body class="bg-gray-100">
    <!-- Navigation -->
    <nav class="bg-gradient-to-r from-green-600 to-green-700 shadow-lg">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <a href="index.php" class="text-white text-2xl font-bold">⚽ لوحة التحكم</a>
                </div>
                <div class="flex items-center space-x-4 space-x-reverse">
                    <span class="text-white"><?php echo $_SESSION['username']; ?></span>
                    <a href="logout.php" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg">تسجيل الخروج</a>
                </div>
            </div>
        </div>
    </nav>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <div class="flex justify-between items-center mb-8">
            <h1 class="text-3xl font-bold text-gray-800">⚽ إدارة المباريات</h1>
            <button onclick="openModal()" class="bg-green-600 hover:bg-green-700 text-white px-6 py-3 rounded-lg font-semibold shadow-md transition">
                ➕ إضافة مباراة جديدة
            </button>
        </div>

        <?php if (isset($success)): ?>
        <div class="bg-green-100 border-r-4 border-green-500 text-green-700 p-4 rounded mb-6">
            <?php echo $success; ?>
        </div>
        <?php endif; ?>

        <?php if (isset($error)): ?>
        <div class="bg-red-100 border-r-4 border-red-500 text-red-700 p-4 rounded mb-6">
            <?php echo $error; ?>
        </div>
        <?php endif; ?>

        <!-- Matches Table -->
        <div class="bg-white rounded-lg shadow-md overflow-hidden">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">#</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الحالة</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الدوري</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">المباراة</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">النتيجة</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الوقت</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">إجراءات</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php foreach ($matches as $m):
                        $status_colors = [
                            'live' => 'bg-red-100 text-red-800',
                            'upcoming' => 'bg-blue-100 text-blue-800',
                            'finished' => 'bg-gray-100 text-gray-800'
                        ];
                        $status_text = [
                            'live' => '🔴 مباشر',
                            'upcoming' => '📅 قادمة',
                            'finished' => '✅ انتهت'
                        ];
                    ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo $m['id']; ?></td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo $status_colors[$m['status']]; ?>">
                                <?php echo $status_text[$m['status']]; ?>
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo $m['league_name']; ?></td>
                        <td class="px-6 py-4 text-sm font-medium">
                            <?php echo $m['home_team'] . ' 🆚 ' . $m['away_team']; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="font-bold text-lg"><?php echo $m['home_score'] . ' - ' . $m['away_score']; ?></span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <?php echo date('Y-m-d H:i', strtotime($m['match_time'])); ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2 space-x-reverse">
                            <a href="edit_match.php?id=<?php echo $m['id']; ?>" class="text-blue-600 hover:text-blue-900">✏️ تعديل</a>
                            <a href="match_streams.php?id=<?php echo $m['id']; ?>" class="text-green-600 hover:text-green-900">📡 البث</a>
                            <form method="POST" class="inline" onsubmit="return confirm('هل أنت متأكد من الحذف؟');">
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="id" value="<?php echo $m['id']; ?>">
                                <button type="submit" class="text-red-600 hover:text-red-900">🗑️ حذف</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Add Match Modal -->
    <div id="matchModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
        <div class="relative top-20 mx-auto p-8 border w-full max-w-2xl shadow-lg rounded-lg bg-white">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-2xl font-bold text-gray-900">➕ إضافة مباراة جديدة</h3>
                <button onclick="closeModal()" class="text-gray-400 hover:text-gray-600 text-3xl">&times;</button>
            </div>

            <form method="POST" class="space-y-4">
                <input type="hidden" name="action" value="create">

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">الدوري</label>
                        <select name="league_id" required class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-green-500">
                            <option value="">اختر الدوري</option>
                            <?php foreach ($leagues as $league): ?>
                            <option value="<?php echo $league['id']; ?>"><?php echo $league['name_ar']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">الحالة</label>
                        <select name="status" required class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-green-500">
                            <option value="upcoming">قادمة</option>
                            <option value="live">مباشرة</option>
                            <option value="finished">منتهية</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">الفريق الأول</label>
                        <select name="home_team_id" required class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-green-500">
                            <option value="">اختر الفريق</option>
                            <?php foreach ($teams as $team): ?>
                            <option value="<?php echo $team['id']; ?>"><?php echo $team['name_ar']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">الفريق الثاني</label>
                        <select name="away_team_id" required class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-green-500">
                            <option value="">اختر الفريق</option>
                            <?php foreach ($teams as $team): ?>
                            <option value="<?php echo $team['id']; ?>"><?php echo $team['name_ar']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">نتيجة الفريق الأول</label>
                        <input type="number" name="home_score" value="0" min="0" class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-green-500">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">نتيجة الفريق الثاني</label>
                        <input type="number" name="away_score" value="0" min="0" class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-green-500">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">وقت المباراة</label>
                        <input type="datetime-local" name="match_time" required class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-green-500">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">الدقيقة الحالية</label>
                        <input type="number" name="current_minute" min="0" max="120" class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-green-500">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">الملعب</label>
                        <input type="text" name="stadium" class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-green-500">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">الحكم</label>
                        <input type="text" name="referee" class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-green-500">
                    </div>
                </div>

                <div class="flex justify-end space-x-4 space-x-reverse pt-4">
                    <button type="button" onclick="closeModal()" class="px-6 py-2 border border-gray-300 rounded-lg hover:bg-gray-50">
                        إلغاء
                    </button>
                    <button type="submit" class="px-6 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700">
                        ✅ حفظ
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function openModal() {
            document.getElementById('matchModal').classList.remove('hidden');
        }

        function closeModal() {
            document.getElementById('matchModal').classList.add('hidden');
        }
    </script>
</body>
</html>

