<?php
session_start();

// التحقق من تسجيل الدخول
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

include_once 'config/database.php';
$database = new Database();
$db = $database->getConnection();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة التحكم - تطبيق كرة القدم</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Cairo', sans-serif;
        }
    </style>
</head>
<body class="bg-gray-100">
    <!-- Navigation -->
    <nav class="bg-gradient-to-r from-green-600 to-green-700 shadow-lg">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <span class="text-white text-2xl font-bold">⚽ لوحة التحكم</span>
                </div>
                <div class="flex items-center space-x-4 space-x-reverse">
                    <span class="text-white"><?php echo $_SESSION['username']; ?></span>
                    <a href="logout.php" class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg transition">
                        تسجيل الخروج
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <div class="flex">
        <!-- Sidebar -->
        <aside class="w-64 bg-white shadow-lg min-h-screen">
            <nav class="mt-6">
                <a href="index.php" class="flex items-center px-6 py-3 text-gray-700 bg-green-50 border-r-4 border-green-600">
                    <span class="mx-3">📊 الرئيسية</span>
                </a>
                <a href="matches.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-green-50 transition">
                    <span class="mx-3">⚽ إدارة المباريات</span>
                </a>
                <a href="teams.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-green-50 transition">
                    <span class="mx-3">🛡️ إدارة الفرق</span>
                </a>
                <a href="leagues.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-green-50 transition">
                    <span class="mx-3">🏆 إدارة الدوريات</span>
                </a>
                <a href="streams.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-green-50 transition">
                    <span class="mx-3">📡 إدارة البث</span>
                </a>
                <a href="settings.php" class="flex items-center px-6 py-3 text-gray-700 hover:bg-green-50 transition">
                    <span class="mx-3">⚙️ الإعدادات</span>
                </a>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 p-8">
            <h1 class="text-3xl font-bold text-gray-800 mb-8">مرحباً بك في لوحة التحكم</h1>

            <!-- Statistics Cards -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                <?php
                // إحصائيات المباريات
                $stmt = $db->query("SELECT COUNT(*) as total FROM matches WHERE status = 'live'");
                $live_matches = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

                $stmt = $db->query("SELECT COUNT(*) as total FROM matches WHERE status = 'upcoming'");
                $upcoming_matches = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

                $stmt = $db->query("SELECT COUNT(*) as total FROM teams WHERE is_active = 1");
                $total_teams = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

                $stmt = $db->query("SELECT COUNT(*) as total FROM leagues WHERE is_active = 1");
                $total_leagues = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
                ?>

                <!-- Live Matches -->
                <div class="bg-white rounded-lg shadow-md p-6 border-r-4 border-red-500">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray-500 text-sm">المباريات المباشرة</p>
                            <p class="text-3xl font-bold text-gray-800"><?php echo $live_matches; ?></p>
                        </div>
                        <div class="bg-red-100 rounded-full p-3">
                            <span class="text-3xl">🔴</span>
                        </div>
                    </div>
                </div>

                <!-- Upcoming Matches -->
                <div class="bg-white rounded-lg shadow-md p-6 border-r-4 border-blue-500">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray-500 text-sm">المباريات القادمة</p>
                            <p class="text-3xl font-bold text-gray-800"><?php echo $upcoming_matches; ?></p>
                        </div>
                        <div class="bg-blue-100 rounded-full p-3">
                            <span class="text-3xl">📅</span>
                        </div>
                    </div>
                </div>

                <!-- Total Teams -->
                <div class="bg-white rounded-lg shadow-md p-6 border-r-4 border-green-500">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray-500 text-sm">إجمالي الفرق</p>
                            <p class="text-3xl font-bold text-gray-800"><?php echo $total_teams; ?></p>
                        </div>
                        <div class="bg-green-100 rounded-full p-3">
                            <span class="text-3xl">🛡️</span>
                        </div>
                    </div>
                </div>

                <!-- Total Leagues -->
                <div class="bg-white rounded-lg shadow-md p-6 border-r-4 border-purple-500">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-gray-500 text-sm">إجمالي الدوريات</p>
                            <p class="text-3xl font-bold text-gray-800"><?php echo $total_leagues; ?></p>
                        </div>
                        <div class="bg-purple-100 rounded-full p-3">
                            <span class="text-3xl">🏆</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Matches -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="text-2xl font-bold text-gray-800 mb-6">آخر المباريات</h2>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الحالة</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الدوري</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">المباراة</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">النتيجة</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الوقت</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">إجراءات</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php
                            $stmt = $db->query("
                                SELECT
                                    m.*,
                                    l.name_ar as league_name,
                                    ht.name_ar as home_team,
                                    at.name_ar as away_team
                                FROM matches m
                                LEFT JOIN leagues l ON m.league_id = l.id
                                LEFT JOIN teams ht ON m.home_team_id = ht.id
                                LEFT JOIN teams at ON m.away_team_id = at.id
                                ORDER BY m.match_time DESC
                                LIMIT 10
                            ");

                            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)):
                                $status_colors = [
                                    'live' => 'bg-red-100 text-red-800',
                                    'upcoming' => 'bg-blue-100 text-blue-800',
                                    'finished' => 'bg-gray-100 text-gray-800'
                                ];
                                $status_text = [
                                    'live' => '🔴 مباشر',
                                    'upcoming' => '📅 قادمة',
                                    'finished' => '✅ انتهت'
                                ];
                            ?>
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo $status_colors[$row['status']]; ?>">
                                        <?php echo $status_text[$row['status']]; ?>
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <?php echo $row['league_name']; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                    <?php echo $row['home_team'] . ' vs ' . $row['away_team']; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <span class="font-bold text-lg">
                                        <?php echo $row['home_score'] . ' - ' . $row['away_score']; ?>
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    <?php echo date('Y-m-d H:i', strtotime($row['match_time'])); ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <a href="edit_match.php?id=<?php echo $row['id']; ?>" class="text-blue-600 hover:text-blue-900 ml-4">تعديل</a>
                                    <a href="match_details.php?id=<?php echo $row['id']; ?>" class="text-green-600 hover:text-green-900">تفاصيل</a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </main>
    </div>

    <script>
        // تحديث تلقائي للصفحة كل 30 ثانية
        setTimeout(function(){
            location.reload();
        }, 30000);
    </script>
</body>
</html>

