# ⚡ دليل التثبيت السريع - Quick Installation Guide

## 🚀 5 دقائق للتشغيل!

### الخطوة 1️⃣: تثبيت XAMPP

```
1. حمّل XAMPP من: https://www.apachefriends.org
2. ثبّت XAMPP في C:\xampp
3. افتح XAMPP Control Panel
4. شغّل Apache و MySQL
```

### الخطوة 2️⃣: إنشاء قاعدة البيانات

```
1. افتح المتصفح: http://localhost/phpmyadmin
2. اضغط "New" أو "جديد"
3. اسم قاعدة البيانات: football_app
4. Collation: utf8mb4_unicode_ci
5. اضغط "Create" أو "إنشاء"
6. اضغط على "Import" أو "استيراد"
7. اختر ملف: api/database/schema.sql
8. اضغط "Go" أو "تنفيذ"
```

### الخطوة 3️⃣: نسخ الملفات

```
1. انسخ مجلد "api" كاملاً
2. الصقه في: C:\xampp\htdocs\
3. أعد تسمية المجلد إلى: football_app
   (أو احتفظ بـ api إذا أردت)
```

### الخطوة 4️⃣: تكوين الاتصال

```
1. افتح: C:\xampp\htdocs\football_app\config\database.php
2. تأكد من البيانات:
   - host: localhost
   - db_name: football_app
   - username: root
   - password: (فارغ غالباً في XAMPP)
```

### الخطوة 5️⃣: تسجيل الدخول

```
1. افتح المتصفح
2. اذهب إلى: http://localhost/football_app/admin/login.php
3. استخدم:
   👤 المستخدم: admin
   🔑 كلمة المرور: admin123
4. اضغط "تسجيل الدخول"
```

---

## ✅ اختبار API

افتح في المتصفح:
```
http://localhost/football_app/matches/read.php
```

يجب أن ترى:
```json
{
  "success": false,
  "message": "لا توجد مباريات"
}
```

---

## 🎯 الخطوات التالية

1. ✅ **أضف مباراة جديدة** من لوحة التحكم
2. ✅ **أضف مصادر بث** للمباراة
3. ✅ **اربط Flutter App** مع API

---

## 🔗 روابط مهمة

```
🏠 لوحة التحكم:
http://localhost/football_app/admin/

📡 API المباريات:
http://localhost/football_app/matches/read.php

🔴 المباريات المباشرة:
http://localhost/football_app/matches/read.php?status=live

📅 المباريات القادمة:
http://localhost/football_app/matches/read.php?status=upcoming
```

---

## ⚠️ مشاكل شائعة وحلولها

### المشكلة: "Access denied for user"
```
الحل:
1. افتح database.php
2. تأكد من username: root
3. تأكد من password: (فارغ أو كلمة مرورك)
```

### المشكلة: "Table doesn't exist"
```
الحل:
1. ارجع لـ phpMyAdmin
2. استورد schema.sql مرة أخرى
3. تأكد من اسم قاعدة البيانات: football_app
```

### المشكلة: صفحة بيضاء فارغة
```
الحل:
1. افتح database.php
2. أضف في البداية:
   error_reporting(E_ALL);
   ini_set('display_errors', 1);
3. حدّث الصفحة لترى الخطأ
```

### المشكلة: "Not Found" 404
```
الحل:
1. تأكد من مسار المجلد الصحيح
2. تأكد من تشغيل Apache في XAMPP
3. جرّب: http://localhost/
```

---

## 📱 ربط Flutter App

في ملف `match_provider.dart`:

```dart
// استبدل الـ API URL
final response = await http.get(
  Uri.parse('http://YOUR_IP_ADDRESS/football_app/matches/read.php'),
);

// مثال:
// http://192.168.1.100/football_app/matches/read.php
// (استخدم IP الجهاز للاختبار على الموبايل)
```

---

## 🎉 تمام!

الآن لديك:
- ✅ لوحة تحكم كاملة
- ✅ API جاهز للاستخدام
- ✅ قاعدة بيانات جاهزة
- ✅ مصادر بث قابلة للإدارة

**ابدأ بإضافة المباريات وروابط البث! ⚽🚀**

